%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: read_picarro_ch4_nodata
%
% Scope:    generate an empty structure for missing PICARRO G2401 data file
%
% Input:    data (structure),
%           data_ch4 (structure)
%
% Output:   empty "data_ch4" struture containing (all NaN values)   
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function data_ch4 = read_picarro_ch4_nodata(data,data_ch4)

fprintf('Warning: No PICARRO G2401 data file selected (no CH4,CO,CO2 data available)\n');

data_ch4.data_idx=0;    %index to keep track if a file is uploaded

data_ch4.start_time=data.start_time;
data_ch4.end_time=data.end_time;
data_ch4.start_time_string=data.start_time_string;
data_ch4.end_time_string=data.end_time_string;

data_ch4.all(1,1)=data.all(1,1);
data_ch4.all(1,2)=data.all(1,2);
data_ch4.all(2,1)=data.all(end,1);
data_ch4.all(2,2)=data.all(end,2);

data_ch4.all(1:2,3:8)=NaN;

% define variable names for plot labels (with units)
data_ch4.varlabels ={join(['Time [h] since',extractBefore(data_ch4.start_time_string,5),'-01-01 00:00:00']),...
                    join(['Time [h] since',extractBefore(data_ch4.start_time_string,20)]),...
                    'CH_4 [ppm]',...
                    'CO [ppm]',...        
                    'CO_2 [ppm]',...        
                    'H_2O [%]',...
                    '{\itp}_{Cell} [mTorr]',...
                    '{\itT}_{Cell} [°C]'};
end